/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.coremods;

import java.lang.reflect.Modifier;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.neoforged.neoforge.coremods.CoremodUtils;
import net.neoforged.neoforgespi.transformation.ProcessorName;
import net.neoforged.neoforgespi.transformation.SimpleClassProcessor;
import net.neoforged.neoforgespi.transformation.SimpleTransformationContext;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ReplaceFieldWithGetterAccess
extends SimpleClassProcessor {
    private final Map<String, String> fieldToMethod;
    private final Set<SimpleClassProcessor.Target> targets;
    private final String className;

    public ReplaceFieldWithGetterAccess(String className, Map<String, String> fieldToMethod) {
        this.targets = Set.of(new SimpleClassProcessor.Target(className));
        this.fieldToMethod = fieldToMethod;
        this.className = className;
    }

    public ProcessorName name() {
        String owner = this.className.toLowerCase(Locale.ROOT).replace('$', '.');
        return new ProcessorName("neoforge.coremods", "field_to_getter." + owner);
    }

    public Set<SimpleClassProcessor.Target> targets() {
        return this.targets;
    }

    public void transform(ClassNode input, SimpleTransformationContext context) {
        for (Map.Entry<String, String> entry : this.fieldToMethod.entrySet()) {
            ReplaceFieldWithGetterAccess.redirectFieldToMethod(input, entry.getKey(), entry.getValue());
        }
    }

    private static void redirectFieldToMethod(ClassNode classNode, String fieldName, @Nullable String methodName) {
        FieldNode foundField = CoremodUtils.getFieldByName(classNode, fieldName);
        if (!Modifier.isPrivate(foundField.access) || Modifier.isStatic(foundField.access)) {
            throw new IllegalStateException("Field " + fieldName + " in " + classNode.name + " is not private and an instance field");
        }
        String methodDescriptor = "()" + foundField.desc;
        MethodNode foundMethod = CoremodUtils.getMethodByDescriptor(classNode, methodName, methodDescriptor);
        for (MethodNode methodNode : classNode.methods) {
            if (methodNode == foundMethod || Objects.equals(methodNode.desc, methodDescriptor)) continue;
            ListIterator iterator = methodNode.instructions.iterator();
            while (iterator.hasNext()) {
                AbstractInsnNode insnNode = (AbstractInsnNode)iterator.next();
                if (insnNode.getOpcode() != 180) continue;
                FieldInsnNode fieldInsnNode = (FieldInsnNode)insnNode;
                if (!Objects.equals(fieldInsnNode.name, fieldName)) continue;
                iterator.remove();
                MethodInsnNode replace = new MethodInsnNode(182, classNode.name, foundMethod.name, foundMethod.desc, false);
                iterator.add(replace);
            }
        }
    }
}

